unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, Buttons, ExtCtrls,
  USG;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    imgKONIEC: TImage;
    btnSAVE: TBitBtn;
    btnLOAD: TBitBtn;
    sg: TStringGrid;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnLOADClick(Sender: TObject);
    procedure btnSAVEClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure imgKONIECClick(Sender: TObject);

  private
	 Lista_Lp       : TStringList;
	 Lista_Nazwisko : TStringList;
	 Lista_Imie     : TStringList;
	 Lista_Ulica    : TStringList;
	 Lista_Kodp     : TStringList;
	 Lista_Miasto   : TStringList;
	 Lista_Dataur   : TStringList;
	 Lista_Pesel    : TStringList;
	 Lista_Tel      : TStringList;
	 Lista_Email    : TStringList;
	 Lista_Woj      : TStringList;
	 Lista_Zarobek  : TStringList;

  public
	 procedure Koniec();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}

procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.btnSAVEClick(Sender: TObject);
begin
   sg.Cols[ 0].Assign(Lista_Lp       );
   sg.Cols[ 1].Assign(Lista_Nazwisko );
   sg.Cols[ 2].Assign(Lista_Imie     );
   sg.Cols[ 3].Assign(Lista_Ulica    );
   sg.Cols[ 4].Assign(Lista_Kodp     );
   sg.Cols[ 5].Assign(Lista_Miasto   );
   sg.Cols[ 6].Assign(Lista_Dataur   );
   sg.Cols[ 7].Assign(Lista_Pesel    );
   sg.Cols[ 8].Assign(Lista_Tel      );
   sg.Cols[ 9].Assign(Lista_Email    );
   sg.Cols[10].Assign(Lista_Woj      );
   sg.Cols[11].Assign(Lista_Zarobek  );

   sg.Cols[ 0].SaveToFile(ExtractFilePath(Application.ExeName) + 'col0.txt');
   sg.Cols[ 1].SaveToFile(ExtractFilePath(Application.ExeName) + 'col1.txt');
   sg.Cols[ 2].SaveToFile(ExtractFilePath(Application.ExeName) + 'col2.txt');
   sg.Cols[ 3].SaveToFile(ExtractFilePath(Application.ExeName) + 'col3.txt');
   sg.Cols[ 4].SaveToFile(ExtractFilePath(Application.ExeName) + 'col4.txt');
   sg.Cols[ 5].SaveToFile(ExtractFilePath(Application.ExeName) + 'col5.txt');
   sg.Cols[ 6].SaveToFile(ExtractFilePath(Application.ExeName) + 'col6.txt');
   sg.Cols[ 7].SaveToFile(ExtractFilePath(Application.ExeName) + 'col7.txt');
   sg.Cols[ 8].SaveToFile(ExtractFilePath(Application.ExeName) + 'col8.txt');
   sg.Cols[ 9].SaveToFile(ExtractFilePath(Application.ExeName) + 'col9.txt');
   sg.Cols[10].SaveToFile(ExtractFilePath(Application.ExeName) + 'col10.txt');
   sg.Cols[11].SaveToFile(ExtractFilePath(Application.ExeName) + 'col11.txt');

   sg.RowCount := 0;
   sg.ColCount := 0;
end;

procedure TMainForm.btnLOADClick(Sender: TObject);
var
	warunek : Boolean;

begin
	warunek := false;

   warunek := FileExists('col0.txt')  and
              FileExists('col1.txt')  and
              FileExists('col2.txt')  and
              FileExists('col3.txt')  and
              FileExists('col4.txt')  and
              FileExists('col5.txt')  and
              FileExists('col6.txt')  and
              FileExists('col7.txt')  and
              FileExists('col8.txt')  and
              FileExists('col9.txt')  and
              FileExists('col10.txt') and
              FileExists('col11.txt');

   if not warunek then
   begin
   	exit;
   end;

   sg.ColCount :=  0;
   sg.RowCount :=  0;

	Lista_Lp.LoadFromFile('col0.txt');
	Lista_Nazwisko.LoadFromFile('col1.txt');
	Lista_Imie.LoadFromFile('col2.txt');
	Lista_Ulica.LoadFromFile('col3.txt');
	Lista_Kodp.LoadFromFile('col4.txt');
	Lista_Miasto.LoadFromFile('col5.txt');
	Lista_Dataur.LoadFromFile('col6.txt');
	Lista_Pesel.LoadFromFile('col7.txt');
	Lista_Tel.LoadFromFile('col8.txt');
	Lista_Email.LoadFromFile('col9.txt');
	Lista_Woj.LoadFromFile('col10.txt');
	Lista_Zarobek.LoadFromFile('col11.txt');


	sg.ColCount := 12;

	sg.Cols[ 0].Assign(Lista_Lp);
	sg.Cols[ 1].Assign(Lista_Nazwisko);
	sg.Cols[ 2].Assign(Lista_Imie);
	sg.Cols[ 3].Assign(Lista_Ulica);
	sg.Cols[ 4].Assign(Lista_Kodp);
	sg.Cols[ 5].Assign(Lista_Miasto);
	sg.Cols[ 6].Assign(Lista_Dataur);
	sg.Cols[ 7].Assign(Lista_Pesel);
	sg.Cols[ 8].Assign(Lista_Tel);
	sg.Cols[ 9].Assign(Lista_Email);
	sg.Cols[10].Assign(Lista_Woj);
	sg.Cols[11].Assign(Lista_Zarobek);

	sg.RowCount  := Lista_Lp.Count;
   sg.FixedRows := 1;
   sg.FixedCols := 1;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
	Lista_Lp       := TStringList.Create();
	Lista_Nazwisko := TStringList.Create();
	Lista_Imie     := TStringList.Create();
	Lista_Ulica    := TStringList.Create();
	Lista_Kodp     := TStringList.Create();
	Lista_Miasto   := TStringList.Create();
	Lista_Dataur   := TStringList.Create();
	Lista_Pesel    := TStringList.Create();
	Lista_Tel      := TStringList.Create();
	Lista_Email    := TStringList.Create();
	Lista_Woj      := TStringList.Create();
	Lista_Zarobek  := TStringList.Create();
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
   if Assigned(Lista_Lp) then
   begin
		Lista_Lp.Clear();
		FreeAndNil(Lista_Lp);
   end;

   if Assigned(Lista_Nazwisko) then
   begin
		Lista_Nazwisko.Clear();
		FreeAndNil(Lista_Nazwisko);
   end;

   if Assigned(Lista_Imie) then
   begin
		Lista_Imie.Clear();
		FreeAndNil(Lista_Imie);
   end;

   if Assigned(Lista_Ulica) then
   begin
		Lista_Ulica.Clear();
		FreeAndNil(Lista_Ulica);
   end;

   if Assigned(Lista_Kodp) then
   begin
		Lista_Kodp.Clear();
		FreeAndNil(Lista_Kodp);
   end;

   if Assigned(Lista_Miasto) then
   begin
		Lista_Miasto.Clear();
		FreeAndNil(Lista_Miasto);
   end;

   if Assigned(Lista_Dataur) then
   begin
		Lista_Dataur.Clear();
		FreeAndNil(Lista_Dataur);
   end;

   if Assigned(Lista_Pesel) then
   begin
		Lista_Pesel.Clear();
		FreeAndNil(Lista_Pesel);
   end;

   if Assigned(Lista_Tel) then
   begin
		Lista_Tel.Clear();
		FreeAndNil(Lista_Tel);
   end;

   if Assigned(Lista_Email) then
   begin
		Lista_Email.Clear();
		FreeAndNil(Lista_Email);
   end;

   if Assigned(Lista_Woj) then
   begin
		Lista_Woj.Clear();
		FreeAndNil(Lista_Woj);
   end;

   if Assigned(Lista_Zarobek) then
   begin
		Lista_Zarobek.Clear();
		FreeAndNil(Lista_Zarobek);
   end;
end;

procedure TMainForm.FormShow(Sender: TObject);
var
	ob : MSg;

begin
	sg.Align := alClient;

	ob := MSg.Create(sg);
   ob.Wypelnij();
   FreeAndNil(ob);
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

end.
